 {
TubeUtils - Funcionalidades para acesso a API do YouTube
Por Fabiano Ferreira
Modularizado, adaptado e gambiarrado para o BaixaTube por Lucas Alexandre
}

unit tubeutils;
{$H+}
interface
uses classes, dvcrt, dvwin, dvForm, dvInet, HTTPApp, pipe, VTREDE,
superObject, shellAPI, sysUtils, windows;

const
MAXFORMATOS=6;
MAXFMTV=10;
MAXFMTA=9;
fmtAudio: array[1..9] of string[4] = (
 'MP3','WAV','WMA','AAC','OGG','M4A','CAF','AMR','FLAC'
);

fmtVideo: array[1..10] of string[4] = (
    'AVI', '3GP', 'FLV', 'MP4', 'MKV', 'WMV', 'MOV', 'MPG', 'M4V','RMVB'
    );
    YOUTUBEKEY = 'AIzaSyCGfFsZK-lu_Ej4HnVmA7QaKothjxOpje8';
    GOOGLEAPIHOST = 'www.googleapis.com';
    YOUTUBESEARCHURL = '/youtube/v3/search';
    YOUTUBEVIDEOSURL = '/youtube/v3/videos';
    MAXRESULTS = 25;

type
    TInfoFilme = record
        id: string;
        titulo, autor, conteudo: string;
        paginaWeb: string;
        duracao, visualizacoes: integer;
    end;

var
cAjuda: array[1..10] of string=(
'ENTER - Toca o vdeo',
'Ctrl + Enter - Inicia a reproduo do vdeo no navegador',
'S - Inicia o download do vdeo',
'I - Informaes sobre o vdeo',
'P - Avana para a prxima pgina de vdeos',
'A - Retrocede para a pgina de vdeos anterior',
'Q - Informa a posio do vdeo na lista',
'ctrl+c - copia o ttulo e o link do vdeo',
'ctrl+l - copia o link do vdeo atual',
'ESC - Cancelar'
);
bipando: boolean=true;
c: char;
fmt: byte=1;
fmts: array[1..MAXFORMATOS] of string;
    lido: ISuperObject;
    lidoInfo: ISuperObject;
linkversao: string;
    listaDeFilmes: TSuperArray;
param1, param2: string;
    quantNoYouTube: integer;
    tokenPag, tokenPagAnt, tokenProxPag: string;

cfg: string;
conf: text;
ffmpeg: string;
youtubedl: string;
player: string;


function versaoAtual: string;
procedure processaBusca (busca: string);
function pedeListaVideos (busca: string): string;
function pedeInfoVideos (id: string): string;
function pedeAoYoutube (pedidoHTTP: string): string;
function formata (s: string): string;
function montaFolheamento (s: string; indice_atual: integer): boolean;
procedure processaFuncao (c1, c2: char;                          ultFolheado: integer;                          var indice_atual: integer;
var mudouPagina: boolean);
procedure folheiaVideos (var indice_atual: integer);
function obtemInfoFilme (ultFolheado: integer): TInfoFilme;
procedure cabecalho;
procedure BaixaVideo(video: tInfoFilme; fila: boolean=false);
procedure BaixaExterno(link: string);
procedure TocaVideo(video: tInfoFilme);
function TituloPagina(link: string): string;
procedure AdicionaBusca(item: string);
function ItemBusca(n: integer): string;
function ExisteBusca(s: string): boolean;
function ItemHist(n: integer): string;
procedure AdicionaHist(item: string);
procedure OpcoesVideo(video: tInfoFilme);
procedure TocaNavegador(link: string);
function GetDefaultBrowser: string;
procedure MataProcessos;
function selSetasOpcao: char;
procedure ajuda;
implementation
uses btcfg, btmsg, btvars;

type
pSearchRec = ^TSearchRec;

var
erro: boolean;

procedure MataProcessos;
begin
winExec('taskkill /f /im youtube-dl.exe',0);
winExec('taskkill /f /im mpv.exe',0);
winExec('taskkill /f /im ffmpeg.exe',0);
end;

function ExisteHist(s: string): boolean;
var i: integer;
count: integer;
t: string;
begin
count:=0;
existeHist:=false;
reset(conf);
while t<>'[HISTORICO]' do
readln(conf,t);
for i:=1 to 10 do
begin
readln(conf,t);
if length(t)>3 then inc(count);
if pos(AnsiUpperCase(s),AnsiUpperCase(t))<>0 then
begin
existeHist:=true;
exit;
end;
end;
close(conf);
if count=0 then
ExisteHist:=false; // No existe nenhum vdeo no histrico
end;

function ExisteBusca(s: string): boolean;
var i: integer;
count: integer;
t: string;
begin
count:=0;
existeBusca:=false;
reset(conf);
t:='';
while t<>'[BUSCAS]' do
readln(conf,t);
for i:=1 to 10 do
begin
readln(conf,t);
if length(t)>3 then inc(count);
if pos(AnsiUpperCase(s),AnsiUpperCase(t))<>0 then
begin
existeBusca:=true;
exit;
end;
end;
close(conf);
if count=0 then
ExisteBusca:=false; // No existe nenhuma busca
end;

procedure AdicionaBusca(item: string);
var
arquivo: TStringList;
i,j: integer;
s: string;
label grava;
begin
arquivo:=TStringList.Create;
reset(conf);
while s<>'[BUSCAS]' do
begin
readln(conf,s);
arquivo.Add(s);
end;

arquivo.Add('1='+item);

for i:=2 to 10 do
begin
if item='' then
begin
arquivo.Add(intToStr(i)+'=');
continue;
end;
arquivo.Add(intToStr(i)+'='+itemBusca(i-1));
end;

arquivo.Add('');

reset(conf);
while s<>'[HISTORICO]' do readln(conf,s);
arquivo.Add(s);
while not eof(conf) do
begin
readln(conf,s);
arquivo.Add(s);
end;

grava:
rewrite(conf);
for i:=0 to arquivo.Count-1 do writeln(conf,arquivo[i]);
close(conf);
end;

procedure AdicionaHist(item: string);
var
arquivo: TStringList;
i,j,k: integer;
s: string;
 label grava;
begin
arquivo:=TStringList.Create;

reset(conf);
while s<>'[HISTORICO]' do
begin
readln(conf,s);
arquivo.Add(s);
end;

arquivo.Add('1='+item);

for i:=2 to 10 do
begin
if item='' then
begin
arquivo.Add(intToStr(i)+'=');
continue;
end;
arquivo.Add(intToStr(i)+'='+itemHist(i-1));
end;

arquivo.Add('');

grava:
rewrite(conf);
for i:=0 to arquivo.Count-1 do writeln(conf,arquivo[i]);
close(conf);
end;

procedure OpcoesVideo(video: tInfoFilme);
begin
cabecalho;
sintClek;
sintWriteln(video.titulo);
repeat
cabecalho;
mensagem('BTSOPC');
c:=upcase(sintReadKey);
until (c='T') or (c=ENTER) or (C=ESC);
if c=ESC then
begin
mensagem('BTDESIST');
exit;
end;
if c='T' then
TocaVideo(video)
else
BaixaVideo(video);
end;

function ItemBusca(n: integer): string;
var i: integer;
s: string;
begin
ItemBusca:='';
reset(conf);
while s<>'[BUSCAS]' do
readln(conf,s);
for i:=1 to 10 do
begin
readln(conf,s);
delete(s,1,pos('=',s));
if i=n then
ItemBusca:=s;
end;
end;

function ItemHist(n: integer): string;
var i: integer;
s: string;
begin
ItemHist:='';
reset(conf);
while s<>'[HISTORICO]' do
readln(conf,s);
for i:=1 to 10 do
begin
readln(conf,s);
if copy(s,1,pos('=',s)-1)=intToStr(n) then
begin
delete(s,1,pos('=',s));
itemHist:=s;
end;
end;
end;

function selSetasOpcao: char;
var n: integer;
i: integer;
const
    opmenu: string = ENTER + CTLENTER + 'SIPAQ' + ^C + ^L +  ESC;
begin
sintWriteln('Selecione com as setas a opo desejada:');

    popupMenuCria(wherex, wherey, 50, 11, RED);
for i:=1 to 10 do PopUpMenuAdiciona('',cAjuda[i]);
    n := popupMenuSeleciona;
    if (n < 1) then
        result := ' '
    else
        result := opmenu[n];
end;

procedure ajuda;
var i: integer;
begin
    writeln;
sintWriteln('As opes so:');
for i:=1 to 9 do sintWriteln(cAjuda[i]);
    limpaBufTec;
end;

function versaoAtual: string;
var sock: integer;
i: integer;
resposta: TStringList;
s: string;
begin
AbreWinSock;
versaoAtual:=VERSAO;
resposta:=TStringList.Create;
sock:=AbreConexao('lucaspcs.com.br',80);
if sock<=0 then exit;
writelnRede(sock,'GET /baixatube/versao.txt HTTP/1.1');
writelnRede(sock,'Host: lucaspcs.com.br');
writelnRede(sock,'');
while not ChegouRede(sock) do sleep(1);
s:=readlnRede(sock);
resposta.Text:=s;
for i:=0 to resposta.Count-1 do
begin
if length(resposta[i])>0 then
begin
if resposta[i][1]='=' then
begin
versaoAtual:=copy(resposta[i],2,length(resposta[i]));
linkversao:=resposta[i+1];
exit;
end;
end;
end;
end;

function LinkReal(url: string; nomeArq: string=''): string;
var s: string;
c: char;
begin
linkReal:='';
if fileExists(nomeArq) then
begin
mensagem('BTARQEXIST'); {'O arquivo destino'}
sintWriteln(nomeArq);
mensagem('BTSOBRESCR'); {'j existe. Sobrescreve (S/N)?'}
c:=upcase(sintReadKey);
if c='N' then
begin
mensagem('BTDESIST'); {'Desistiu'}
exit;
end;
c:=#0;
end;
appExecute(YOUTUBEDL+' --no-check-certificate --prefer-insecure -f '+fmts[fmt]+' -g '+url);
while processExists('youtube-dl.exe') do
begin
sleep(1); keypressed;
s:=appgetout;
if AnsiUpperCase(copy(s,1,4))='HTTP' then
linkReal:=s;
end;
end;

function DownVideo(arquivo: TSearchRec; nomeArq: string; url: string; fila: boolean=false): boolean;
var c: char;
progresso: integer;
s, t: string;
begin
progresso:=0;
downVideo:=true;
t:=linkReal(url,nomeArq);
if t='' then
begin
downVideo:=false;
exit;
end;
delete(t,length(t)-4,length(t));
t:='ffmpeg -threads 0 -y -i '+t;
t:=t+' -maxrate 100M -bufsize 200M -vcodec copy -b:a 128k "'+nomeArq+'"';
appExecute(t);
if fila then
begin
mensagem('BTADFILA');
exit;
end;
while processExists('ffmpeg.exe') do
begin
s:=appgetout;
if pos('overhead',s)<>0 then
break;
if bipando then sintClek;
delay(500);
if keypressed then
c:=upcase(readkey)
else
c:=#0;
if c=#32 then begin sintBip; if bipando then bipando:=false else bipando:=true; end;
if c=ESC then
begin
sintWriteln('Deseja interromper o download?');
repeat
c:=upcase(sintReadKey);
until (c='S') or (c='N');
if c='S' then
begin
MataProcessos;
sintWriteln('O download foi interrompido');
findfirst('*'+nomeArq+'*',faArchive,arquivo);
DeleteFile(pchar(arquivo.Name));
downVideo:=false;
exit;
end;
end;
if c=ENTER then
begin
s:=appgetout;
if pos('size=',s)=0 then
begin
sintWriteln('Aguardando por informaes de progresso');
continue;
end;
delete(s,1,pos('size=',s)-1);
delete(s,1,5);
s:=trim(s);
s:=copy(s,1,pos('kB',s)-1);
progresso:=strToInt(s) div 1024;
sintWriteln(intToStr(progresso)+' MB baixados e convertidos');
end;
c:=#0;
end;
appStop;
end;

function subsCaracInvalidos(s: string) : string;
begin
    s := stringReplace(s,'/','-',[rfreplaceall]);
    s := stringReplace(s,':',' ',[rfreplaceall]);
    s := stringReplace(s,'"','''',[rfreplaceall]);
    s := stringReplace(s,'?',' ',[rfreplaceall]);
    s := stringReplace(s,'<',' ',[rfreplaceall]);
    s := stringReplace(s,'>',' ',[rfreplaceall]);
    s := stringReplace(s,'|',' ',[rfreplaceall]);
    result := trim(s);
end;

function pedeListaVideos (busca: string): string;
var
    s: string;
begin
    busca := stringToURL(busca);
    s := 'GET ' + YOUTUBESEARCHURL + '?key=' + YOUTUBEKEY +
                       '&type=video' +
                       '&part=id,snippet' +
                       '&q=' + busca +
                       '&maxResults=' + intToStr(MAXRESULTS);
    if tokenPag<>'' then
        s := s + '&pageToken='+tokenPag;
    tokenPag := '';

    s := s + ' HTTP/1.0';
    result := s;
end;

function pedeInfoVideos (id: string): string;
var
    s: string;
begin
    s := 'GET ' + YOUTUBEVIDEOSURL + '?key=' + YOUTUBEKEY +
                       '&part=id,contentDetails,statistics' +
                       '&id=' + id;
    s := s + ' HTTP/1.0';
    result := s;
end;

function pedeAoYoutube (pedidoHTTP: string): string;
var
    pbuf: PbufRede;
    s: string;
    c: char;
    ok: boolean;
    sock: integer;
begin
    abreWinsock;
    sock := abreConexaossl ('gdata.youtube.com', 443);
    if sock <= 0 then
        begin
    mensagem('BTNCON');
            result := '';
            exit;
        end;

    writelnRede (sock, pedidoHttp);
    writelnRede (sock, 'Host: ' + GOOGLEAPIHOST);
    writelnRede (sock, 'User-Agent: Webvox 5.2d');
    writelnRede (sock, 'Accept-Language: pt-br');
    writelnRede (sock, 'UA-CPU: x86');
    writelnRede (sock, '');

    pbuf := inicBufRede (sock);
    repeat
        ok := readlnBufRede(pbuf, s, 500);
    until (not ok) or (s = '');

    s := '';
    repeat
        while not temDadoBufRede(pbuf) do delay (1000);
        ok := leCaracBufRede(pbuf, c);
        if ok then s := s + c;
    until not ok;

    fimBufRede (pbuf);
    fechaConexao (sock);
    result := s;
    fechaWinsock;
end;

function formata (s: string): string;
var
    saida: string;
begin
    saida := '';
    textColor (White);
    while (s <> '') do
        if copy (s, 1, 6) = '&quot;' then
            begin
                saida := saida + '"';
                delete (s, 1, 6);
            end
        else
        if copy (s, 1, 5) = '&#39;' then
            begin
                saida := saida + '''';
                delete (s, 1, 5);
            end
        else
        if (copy (s, 1, 3) = '<b>') OR
           (copy (s, 1, 3) = '<i>') then   delete (s, 1, 3)
        else
        if (copy (s, 1, 4) = '</b>') or
           (copy (s, 1, 4) = '</i>') then  delete (s, 1, 4)

        else
            begin
                saida := saida + s[1];
                delete (s, 1, 1);
            end;
    result := saida;
end;

function montaFolheamento (s: string; indice_atual: integer): boolean;   // retorna tambm a lista de filmes
var
    filme: ISuperObject;
    titulo: string;
    wstring: WideString;
    i: integer;
    nLidos: integer;
begin
    wstring := s;  // Superobject s trabalha com widestring
    lido := TSuperObject.ParseString2(pWideChar(wstring));

    try
        listaDeFilmes := lido['items'].AsArray;
        nlidos := listaDeFilmes.Length;
        quantNoYouTube := lido['pageInfo']['totalResults'].asInteger;
    except
        quantNoYouTube := 0;
        nlidos := 0;
    end;

    try
        tokenPagAnt := lido['prevPageToken'].asString;
    except
        tokenPagAnt := '';
    end;
    try
        tokenProxPag := lido['nextPageToken'].asString;
    except
        tokenProxPag := '';
    end;

    cabecalho;
    sintWriteInt (nlidos);
    mensagem('BTENCON');

    if (quantNoYouTube <> 0) and (indice_atual = 1) then
        begin
            sintWriteInt (quantNoYouTube);
        end;
    writeln;
    textbackground (RED);
    writeln ('-------------------------------------------------------------------------------');
    textbackground (BLACK);

    window (1, wherey, 80, 25);
    folheiaCria (wherex, wherey, 80, 20);
    for i := 0 to nlidos-1 do
        begin
            filme := listaDeFilmes.O[i];
            s := filme['snippet']['title'].AsString;
            titulo := formata (Utf8ToAnsi(s));
            folheiaAdiciona(titulo);
        end;

    result := nlidos <> 0;
end;

procedure processaFuncao (c1, c2: char;                          ultFolheado: integer;                          var indice_atual: integer;
var mudouPagina: boolean);
var clipboardAcum : string;
    i: integer;
    texto: string;
    estaSelec: boolean;
    infoFilme: TInfoFilme;
    filmeSelec: ISuperObject;

const
    CRLF = ^m^j;
label denovo, informenomedoarquivo, fazdownload;

const
    NOPLAYER = false;
    NONAVEGADOR = true;

begin
denovo:
    clrscr;
    infoFilme := obtemInfoFilme (ultFolheado);
    if infoFilme.titulo='erro' then exit;

bipando:=true;

    case upcase(c1) of
        ESC:  begin
                  indice_atual := 0;
    mensagem('BTFIMFOLH');
              end;

    'S':
            begin
    cabecalho;
    BaixaVideo(infoFilme);
            end;

    ^S:
            begin
    cabecalho;
    BaixaVideo(infoFilme,true);
            end;

        ENTER: TocaVideo(infoFilme);
CTLENTER: tocaNavegador('http://www.youtube.com/watch?v='+infoFilme.id);

        'Q': sintetiza (intToStr (indice_atual+ultFolheado-1));

        'P': if tokenProxPag <> '' then
                 begin
                     indice_atual := indice_atual + 25;
                     tokenPag := tokenProxPag;
                     mudouPagina := true;
    sintWrite('Pgina ');
    sintWriteInt((indice_atual+25) div (25));
                 end
else
sintWriteln('Esta foi a ltima pgina');

        'A': if tokenPagAnt <> '' then
                 begin
                     indice_atual := indice_atual - 25;
                     tokenPag := tokenPagAnt;
                     mudouPagina := true;
    sintWrite('Pgina ');
    sintWriteInt((indice_atual+25) div (25));
                 end
else
sintWriteln('Voc est na primeira pgina');

        'I': begin
                 writeln (infoFilme.titulo);
                 sintClek;
                 sintwriteln('Autor');
                 textColor (yellow);
                 sintWriteln (infoFilme.autor);

                 sintClek;
                 textColor (white);
                 sintWriteln('Durao');
                 textColor (yellow);

                 if (infoFilme.duracao div 60) = 0 then
                     sintWriteln (intToStr (infoFilme.duracao mod 60)
                                 + ' segundos ')
                 else
                     sintWriteln (intToStr (infoFilme.duracao div 60)
                                 + ' minutos '
                                 + intToStr (infoFilme.duracao mod 60)
                                 + ' segundos ');

                 sintClek;
                 textColor (white);
                 sintwriteln('Visualizaes');
                 textColor (yellow);
                 sintWriteln (intToStr(infoFilme.visualizacoes));

                 sintClek;
                 textColor (yellow);
                 sintWriteln (infoFilme.conteudo);
                 textColor (white);
                 writeln;
sintWriteln('Aperte C para copiar as informaes para a rea de transferncia');
if upcase(readkey)='C' then
begin
PutClipBoard(pchar(infoFilme.titulo+#13+#10+infoFilme.paginaWeb+#13+#10+infoFilme. conteudo));
sintClek; sintClek;
end;
             end;

        ^C:  // control-c   -->  titulo<crlf>paginaweb<crlf>
             begin
                clipboardAcum := '';
                for i := 1 to folheiaNumItens do
                    begin
                        folheiaObtemItem(i, texto, estaSelec);
                        if estaSelec then
                            begin
                                filmeSelec := listaDeFilmes.O[i-1];
                                clipboardAcum := clipboardAcum +
                                    Utf8ToAnsi (filmeSelec['snippet']['title'].AsString) + CRLF +
                                    'http://www.youtube.com/watch?v='+
                                    filmeSelec['id']['videoId'].AsString + CRLF;
                            end;
                    end;

                if clipboardAcum = '' then
                    begin
                        filmeSelec := listaDeFilmes.O[ultFolheado-1];
                        clipboardAcum :=
                            Utf8ToAnsi (filmeSelec['snippet']['title'].AsString) + CRLF +
                            'http://www.youtube.com/watch?v='+
                            filmeSelec['id']['videoId'].AsString + CRLF;
                    end;

                putClipboard (pchar(clipboardAcum));
                sintclek;
             end;

        ^l:
            begin
                filmeSelec := listaDeFilmes.O[ultFolheado-1];
                clipboardAcum :=
                            'http://www.youtube.com/watch?v='+
                            filmeSelec['id']['videoId'].AsString + CRLF;

                putClipboard (pchar(clipboardAcum));
                sintclek;
            end;

        #0:  case c2 of
                 F1: ajuda;
                 F9: begin
                        if ultFolheado > 0 then
                            begin
                                writeln (infoFilme.titulo);
                                writeln;
                            end;

                         c1 := selSetasOpcao;
                         goto denovo;
                     end;
             end;
    end;
end;

procedure folheiaVideos (var indice_atual: integer);
var c1, c2: char;
    ultFolheado: integer;
    mudouPagina: boolean;

begin
    ultFolheado := 1;
    repeat
        clrscr;

        if folheiaExecuta(ultFolheado, ultFolheado, c1, c2, true) then
            processaFuncao (c1, c2, ultFolheado, indice_atual, mudouPagina)
        else
            sintBip;

    until mudouPagina or (indice_atual = 0);
end;

function obtemInfoFilme (ultFolheado: integer): TInfoFilme;
var
    s: string;
    p: integer;
    wstring: WideString;
    filmeSelec: ISuperObject;
    infos: TSuperArray;
    infoFilme: TInfoFilme;

begin
    with infoFilme do
        begin
            filmeSelec := listaDeFilmes.O[ultFolheado-1];

            id := filmeSelec['id']['videoId'].AsString;
            s := filmeSelec['snippet']['title'].AsString;
            titulo := formata (Utf8ToAnsi(s));

            s := filmeSelec['snippet']['description'].AsString;
            conteudo := formata (Utf8ToAnsi(s));

            s := filmeSelec['snippet']['channelTitle'].asString;
            autor := formata (Utf8ToAnsi(s));

            paginaWeb:='http://www.youtube.com/watch?v='+filmeSelec['id']['videoId'].AsString;

            s := pedeAoYoutube(pedeInfoVideos(infoFilme.id));
    if s='' then
    begin
    titulo:='erro';
    ObtemInfoFilme:=infoFilme;
    exit;
    end;

            wstring := s;  // Superobject s trabalha com widestring
            lidoInfo := TSuperObject.ParseString2(pWideChar(wstring));

            infos := lidoInfo['items'].AsArray;

            s := infos.O[0]['contentDetails']['duration'].AsString;
            delete (s, 1, 2);

            infoFilme.duracao := 0;
            try
                p := pos ('H', s);
                if p > 0 then
                    begin
                        infoFilme.duracao := infoFilme.duracao +
                                             3600 * strToInt(copy (s, 1, p-1));
                        delete (s, 1, p);
                    end;

                p := pos ('M', s);
                if p > 0 then
                    begin
                        infoFilme.duracao := infoFilme.duracao +
                                             60 * strToInt(copy (s, 1, p-1));
                        delete (s, 1, p);
                    end;

                p := pos ('S', s);
                if p > 0 then
                    begin
                        infoFilme.duracao := infoFilme.duracao +
                                             strToInt(copy (s, 1, p-1));
                        delete (s, 1, p);
                    end;
            except
                infoFilme.duracao := 0;
            end;

            infoFilme.visualizacoes := infos.O[0]['statistics']['viewCount'].AsInteger;
        end;

    result := infoFilme;
end;

procedure processaBusca (busca: string);
var
    indice_atual: integer;
    s: string;

begin
    indice_atual := 1;
    repeat
        gotoxy (1, 3);
        s := pedeAoYoutube (pedeListaVideos(busca));
        if s <> '' then
            begin
                if montaFolheamento (s, indice_atual) then
                     folheiaVideos (indice_atual);
                folheiaDestroi;
            end;
    until (s = '') or (quantNoYouTube = 0) or (indice_atual = 0);
end;

procedure cabecalho;
begin
clrscr;
textBackGround(BLUE);
writeln('BaixaTube - Verso '+VERSAO);
textBackGround(BLACK);
writeln;
end;

function SelecionaFormato: string;
function SelecionaFormatoAudio: string;
var i: integer;
formato: integer;
begin
cabecalho;
mensagem('BTEXTENSAO'); {'Selecione um formato'}
PopUpMenuCria(1,5,3,9,BLACK);
for i := 1 to 9 do PopUpMenuAdiciona('',fmtAudio[i]);
formato:=PopUpMenuSeleciona;
SelecionaFormatoAudio:=fmtAudio[formato];
if formato=0 then
selecionaFormatoAudio:='';
end;

function SelecionaFormatoVideo: string;
var i: integer;
formato: integer;
begin
cabecalho;
mensagem('BTEXTENSAO'); {'Selecione um formato'}
PopUpMenuCria(wherex,wherey,3,9,BLACK);
for i := 1 to 10 do PopUpMenuAdiciona('',fmtVideo[i]);
formato:=PopUpMenuSeleciona;
SelecionaFormatoVideo:=fmtVideo[formato];
if formato=0 then
SelecionaFormatoVideo:='';
end;

var
 tipo: integer;
formato: string[4];
begin
cabecalho;
PopUpMenuCria(1,5,10,2,BLACK);
PopUpMenuAdiciona('','udio');
PopUpMenuAdiciona('','Vdeo');
tipo:=PopUpMenuSeleciona;

if tipo=0 then
selecionaFormato:=''
else
if tipo=1 then
begin
formato:=SelecionaFormatoAudio;
SelecionaFormato:=formato;
end
else
if tipo=2 then
begin
formato:=SelecionaFormatoVideo;
SelecionaFormato:=formato;
end;
end;

procedure TocaNavegador(link: string);
var s: string;
begin
cabecalho;
s:=GetDefaultBrowser+' '+link;
sintWriteln('Abrindo navegador; pressione ALT F4 quando terminar.');
while sintFalando do WaitMessage;
winExec(pchar(s),SW_NORMAL);
while processExists(GetDefaultBrowser) do sleep(1);
end;

function GetDefaultBrowser: string;
var
    tmp : PChar;
    res : PChar;
begin
    tmp := StrAlloc(255);
    res := StrAlloc(255);
    try
        GetTempPath(255,tmp);
        FileCreate(tmp+'htmpl.htm');
        FindExecutable('htmpl.htm',tmp,Res);
        Result := ExtractFilePath(res) + ExtractFileName(res);
        SysUtils.DeleteFile(tmp+'htmpl.htm');
    finally
        StrDispose(tmp);
        StrDispose(res);
    end;
end;

procedure TocaVideo(video: tInfoFilme);
var s: string;
c: char;
pToken: string; { Token da prxima pgina de vdeos }
pv: TStringList; { Lista de prximos vdeos }
url: string;
videoAtual: integer;
label ytdl;
procedure ListaProximosVideos(pToken: string='');
var s: string;
i: integer;
l: TStringList;
begin
l:=TStringList.Create;
videoAtual:=0;
l:=TStringList.Create;
pv:=TStringList.Create;
if pToken<>'' then
s:=PedeAoYoutube('GET https://www.googleapis.com/youtube/v3/search?part=snippet&pageToken='+pToken+'&maxResults=25&relatedToVideoId='+video.id+'&type=video&key='
+YOUTUBEKEY+'&token='+pToken)
else
s:=PedeAoYoutube('GET https://www.googleapis.com/youtube/v3/search?part=snippet&maxResults=25&relatedToVideoId='+video.id+'&type=video&key=' +YOUTUBEKEY);
l.Text:=s;
for i:=0 to l.Count-1 do
begin
if pos('"nextPageToken"',l[i])<>0 then
begin
pToken:=l[i];
delete(pToken,1,19);
delete(pToken,length(pToken)-1,length(pToken));
end;
if pos('"videoId": ',l[i])<>0 then
begin
s:=l[i];
delete(s,1,16);
delete(s,length(s),length(s));
pv.Add(s);
end;
end;
end;
begin
MataProcessos;
fmt:=1;
if length(video.id)=11 then
url:='http://www.youtube.com/watch?v='+video.id
else
url:=video.id;
if not ExisteHist(url+#255+video.titulo) then AdicionaHist(url+#255+video.titulo);
mensagem('BTMOMENTO');
if site.nome='youtube.com' then
ListaProximosVideos;
if confs.altf4='SIM' then
mensagem('BTALTF4');
ytdl:
appExecute(youtubedl+' --no-check-certificate --prefer-insecure -f '+fmts[fmt]+' -g -q '+url);
while (processExists('youtube-dl.exe')) do
begin
keypressed; sleep(1);
s:=appgetout;
if s<>'' then break;
end;
if copy(s,1,4)<>'http' then
begin
if fmt=MAXFORMATOS then
begin
mensagem('BTNCON');
sintWriteln('Vdeo restrito ou problema de conexo');
exit;
end;
inc(fmt);
goto ytdl;
end;
appStop;
winExec(pchar(player+' --title "'+video.titulo+'" '+s),0);
c:=#0;
while (processExists('mpv.exe') or (processExists('mpv.exe'))) do
begin
if keypressed then c:=upcase(readkey);
if c=ESC then break;
c:=#0;
keypressed;  sleep(1);
end;
MataProcessos;
sintSom('EF_FIMREPR'); mensagem('BTFIMREPR');
if site.nome='youtube.com' then
begin
repeat
mensagem('BTSUPROX');
mensagem('BTDSPROX');
c:=upcase(sintReadKey);
until (c='S') or (c='N');
if c='N' then
begin
mensagem('BTOK');
exit;
end;
if c='S' then
begin
if pv.Count=0 then
sintWriteln('No h mais vdeos disponveis');
MataProcessos;
if videoAtual>pv.Count-1 then
ListaProximosVideos(pToken);
mensagem('BTMOMENTO');
url:='http://www.youtube.com/watch?v='+pv[videoAtual];
video.id:=pv[videoAtual];
video.titulo:=TituloPagina(url);
fmt:=1;
inc(videoAtual);
goto ytdl;
end;
end;
end;

function TamanhoArquivo(nomeArq: string): int64;
var
arq: file of byte;
begin
try
assign(arq,nomeArq);
reset(arq);
TamanhoArquivo:=fileSize(arq);
close(arq);
Except
end;
end;
procedure BaixaVideo(video: tInfoFilme; fila: boolean=false);
var url: string;
s: string;
nomeArq: string;
c: char;
formato: string;
arquivo: TSearchRec;
label denovo, pronto;
begin
MataProcessos;
fmt:=1;
if length(video.id)=11 then
url:='http://www.youtube.com/watch?v='+video.id
else
url:=video.id;
nomeArq:=SubsCaracInvalidos(video.titulo);
mensagem('BTFORMATO');
formato:=AnsiLowerCase(selecionaFormato);
if formato='' then
begin
mensagem('BTDESIST');
exit;
end;
if not fila then mensagem('BTBAIXANDO');
if not ExisteHist(url+#255+video.titulo) then AdicionaHist(url+#255+video.titulo);

if not fila then MataProcessos;

denovo:
if fila then
erro:=downVideo(arquivo,nomeArq+'.'+AnsiLowerCase(formato),url,true)
else
erro:=downVideo(arquivo,nomeArq+'.'+AnsiLowerCase(formato),url);
if fila then exit;
findfirst('*'+nomeArq+'*',faArchive,arquivo);

if arquivo.Name='' then
begin
if fmt=MAXFORMATOS then
begin
mensagem('BTERRO');
sintWriteln('Vdeo restrito ou problema de conexo');
exit;
end;
inc(fmt);
goto denovo;
end;
pronto:
MataProcessos;
if not erro then
begin
sintSom('BTFALHA');
mensagem('BTFALHOU');
exit;
end;
delay(500);
sintSom('BTCONCL');
mensagem('BTDNSU');
end;

function TituloPagina(link: string): string;
var dominio: string;
arquivo: string;
sock: integer;
i: integer;
seguranca: boolean;
resposta: TStringList;
s: string;
p,q: integer;
label pedido;
begin
AbreWinSock;
tituloPagina:='';
pedido:

if AnsiUpperCase(copy(link,1,7))='HTTP://' then
begin
delete(link,1,7);
seguranca:=false;
end;
if AnsiUpperCase(copy(link,1,8))='HTTPS://' then
begin
delete(link,1,8);
seguranca:=true;
end;
dominio:=copy(link,1,pos('/',link)-1);
delete(link,1,length(dominio));
arquivo:=link;

resposta:=TStringList.Create;
if seguranca then
sock:=AbreConexaoSSL(dominio,443)
else
sock:=AbreConexao(dominio,80);
if sock<=0 then
begin
mensagem('BTNCON');
exit;
end;
writelnRede(sock,'GET '+arquivo+' HTTP/1.1');
writelnRede(sock,'Host: '+dominio);
writelnRede(sock,'User-Agent: BaixaTube');
writelnRede(sock,'UA-CPU: x86');
writelnRede(sock,'');
while not ChegouRede(sock) do;
s:=ReadlnRede(sock);
resposta.Text:=s;
for i:=0 to resposta.Count-1 do
begin
if pos('HTTP/1.1 2',resposta[i])<>0 then
begin
while pos('<title>',s)=0 do s:=readlnRede(sock);
p:=pos('<title>',s)+7;
q:=pos('</title',s)-1;
s:=copy(s,p,q);
s:=copy(s,1,pos('<',s)-1);
try
tituloPagina:=htmlDecode(utf8toAnsi(s));
Except
end;
end;
if pos('Location: ',resposta[i])<>0 then
begin
link:=copy(resposta[i],11,length(resposta[i]));
FechaConexao(sock);
goto pedido;
end;
if pos('HTTP/1.1 4',resposta[i])<>0 then
begin
mensagem('BTNCON');
exit;
end;
end;
end;

procedure BaixaExterno(link: string);
var formato: string;
nomeArq, titulo: string;
arquivo: TSearchRec;
label denovo;
begin
titulo:=TituloPagina(link);
if titulo='' then exit;
mensagem('BTBXND');
sintWriteln(titulo);
if param2='' then
begin
mensagem('BTFORMATO');
formato:=AnsiLowerCase(selecionaFormato);
mensagem('BTBAIXANDO');
end;
if param1<>'' then formato:=param1;
nomeArq:=subscaracinvalidos(titulo);
if not existeHist(nomeArq+#255+param2) then
AdicionaHist(nomeArq+#255+param2);
fmt:=1;

denovo:
erro:=downVideo(arquivo,nomeArq+'.'+AnsiLowerCase(formato),link);

findfirst('*'+nomeArq+'*',faArchive,arquivo);

if arquivo.Name='' then
begin
if fmt=MAXFORMATOS then
begin
mensagem('BTERRO');
sintWriteln('Vdeo restrito ou problema de conexo');
exit;
end;
inc(fmt);
goto denovo;
end;
MataProcessos;
if not erro then
begin
sintSom('BTFALHA');
mensagem('BTFALHOU');
exit;
end;
delay(500);
sintSom('BTCONCL');
mensagem('BTDNSU');
end;

begin
fmts[1]:='18';
fmts[2]:='http-240';
fmts[3]:='mp4';
fmts[4]:='m4a';
fmts[5]:='webm';
fmts[6]:='flv';
end.
