// http.pas - Interaes com rede e protocolo HTTP para o Pascal
// Aproveitado do abacaxi (unit) do professor Borges.
// Ol amigos!
// Autor: Antnio Borges e Velho Nego

unit http;
interface
uses windows, shellApi, sysUtils,
winsock;

const
diasDaSemana: array[0..6] of string[3]=(
'Sun','Mon','Tue','Wed','Thu','Fri','Sat'
);
nomeMes: array[1..12] of string[3]=(
'Jan','Feb','Mar','Apr','May','Jun','Jul','Ago','Sep','Out','Nov','Dec'
);
    MAXBUF = 4096;

type
    TbufRede = record
        sock: integer;
        buf: array [0..MAXBUF-1] of char;
        p: integer;
        lidos: integer;
    end;

    PbufRede = ^TbufRede;

function abreWinSock: boolean;
procedure fechaWinSock;

procedure descobreMeuIp (var ip, nomeComput: string);
function nomeParaIp (nomeComput: string): longint;

function abreConexao (nomeComput: string; porta: short): integer;
procedure fechaConexao (sock: integer);
function escutaConexao (porta: short): integer;
function aceitaConexao (sock: integer): integer;

function chegouRede (sock: integer): boolean;
function readlnRede (sock: integer): string;
function LeTelnet(sock: integer): string;
function writeRede (sock: integer; s: string): boolean;
function writelnRede (sock: integer; s: string): boolean;

function abreConexaoUDP: integer;
function escutaConexaoUDP (porta: short): integer;
function enviaUDP (sock: integer; buf: PChar; len: integer;
                   ipDestino: longint; porta: short): integer;
function recebeUDP (sock: integer; buf: PChar; tamBuf: integer; var ipOrigem: longint): integer;

function inicBufRede (sock: integer): PbufRede;
procedure fimBufRede (pbuf: PBufRede);
function temDadoBufRede (pbuf: PbufRede): boolean;
function readlnBufRede (pbuf: PbufRede; var s: string; maxTempo: integer): boolean;
function leCaracBufRede (pbuf: PbufRede; var c: char): boolean;
function Requisita(sock: integer; metodo: byte; host: string; dados:
string): string;
procedure AceitaHTTP(sock: integer; codigo: string; conteudo: string);

const
GET=0;
POST=1;

var
    debugConexao: boolean;
    enderLocal, enderRemoto: longint;
                {atualizado quando se conecta ou aceita}
    timeoutChegouRede: integer;

implementation
uses classes, dateutils;

function abreWinSock: boolean;
var
    wsaData: TWSADATA;
begin
    abreWinSock := WSAStartup ($0101, wsaData) = 0;
end;

procedure fechaWinSock;
begin
    WSACleanup;
end;

{ Manda um buffer dali at a esquina }

function sendBuf (sock: integer; buf: pchar; len: integer; flags: integer): integer;
begin
        sendBuf := winsock.send (sock, buf^, len, flags);
end;

function nomeParaIp (nomeComput: string): longint;
var
    hip: phostent;                        { retorna o endereco IP do soquete }
    hostName: array [0..128] of char;
    enderRemoto: longint;

begin
    { Descobre endereco IP do computador }
    strPCopy (hostName, nomeComput);
    if (hostName[0] >= '0') and (hostName[0] <= '9')  then
        enderRemoto := inet_addr (hostName)
    else
        begin
            hip := gethostbyname (hostName);
            if (hip = NIL)  then
                begin
                    nomeParaIp := 0;
                    exit;
                end;
            move (hip^.h_addr_list^^, enderRemoto, 4);
        end;

    nomeParaIp := enderRemoto;
end;

procedure descobreMeuIp (var ip, nomeComput: string);
var
    HEnt: pHostEnt;
    HName: array [0..100] of char;
    i: integer;
begin
    if GetHostName(@HName, SizeOf(HName)) = 0 then
        begin
            HEnt := GetHostByName(HName);
            for i := 0 to HEnt^.h_length - 1 do
                 ip := Concat(ip, IntToStr(Ord(HEnt^.h_addr_list^[i])) + '.');
            delete (ip, Length(ip), 1);
            nomeComput := strPas (HName);
          end
      else
          begin
              ip := '127.0.0.1';
              nomeComput := 'localhost';
          end;
end;

function abreConexao (nomeComput: string; porta: short): integer;
var
    localAddr,                          { descricao dos endereos local e remoto }
    remoteAddr: sockaddr_in;
    ret: integer;
    sock: integer;
    tam: longint;
begin
    abreConexao := -1;

    { cria socket e seleciona porta }

    sock := socket (AF_INET, SOCK_STREAM, IPPROTO_TCP);
    if (sock = -1) then exit;

    fillchar (localAddr, sizeof (localAddr), 0);
    with localAddr do
        begin
            sin_family := AF_INET ;
            sin_addr.s_addr := htonl (INADDR_ANY);
            sin_port := htons (0);
        end;

    ret := bind (sock, localAddr, sizeof(localAddr));
    if (ret = -1)  then exit;

    { Descobre endereco IP do computador }

    enderRemoto := nomeParaIp (nomeComput);
    if enderRemoto = 0 then exit;

    { conecta com servidor }

    fillchar (remoteAddr, sizeof (remoteAddr), 0);
    with remoteAddr do
        begin
            sin_family := AF_INET;
            move (enderRemoto, sin_addr, 4);
            sin_port := word (htons (porta));
        end;

    if (connect (sock, remoteAddr, sizeof (remoteAddr)) = -1) then
         exit;

    tam := sizeof (localAddr);
    getSockName (sock, localAddr, tam);
    enderLocal := localAddr.sin_addr.s_addr;

    timeoutChegouRede := 0;
    abreConexao := sock;
end;

function escutaConexao (porta: short): integer;
var
    localAddr: sockaddr_in;           { descricao dos endereos local e remoto }
    ret: integer;
    sock: integer;
    tam: longint;

begin
    escutaConexao := -1;

    { cria socket e seleciona porta }

    sock := socket (AF_INET, SOCK_STREAM, IPPROTO_TCP);
    if (sock = -1) then exit;

    fillchar (localAddr, sizeof (localAddr), 0);
    with localAddr do
        begin
            sin_family := AF_INET ;
            sin_addr.s_addr := htonl (INADDR_ANY);
            sin_port := word (htons (porta));
        end;

    ret := bind (sock, localAddr, sizeof(localAddr));
    if (ret = -1)  then exit;

    { conecta com servidor }

    if (listen (sock, 3) = -1) then
         exit;

    tam := sizeof (localAddr);
    getSockName (sock, localAddr, tam);
    enderLocal := localAddr.sin_addr.s_addr;

    escutaConexao := sock;
end;

procedure fechaConexao (sock: integer);
begin
    if sock >= 0 then
        closeSocket (sock);
end;

function aceitaConexao (sock: integer): integer;
var
    localAddr,
    remoteAddr: TSockAddr;
    tam: longint;
    newsock: integer;
begin
    aceitaConexao := -1;
    tam := sizeof (remoteAddr);

    newsock := accept (sock, @remoteAddr, @tam);
    if newSock = -1 then exit;

    enderRemoto := remoteAddr.sin_addr.s_addr;

    tam := sizeof (localAddr);
    getSockName (newsock, localAddr, tam);
    enderLocal := localAddr.sin_addr.s_addr;

    aceitaConexao := newsock;
end;

function abreConexaoUDP: integer;
var
    sock: integer;

begin
    abreConexaoUDP := -1;

    { cria socket e seleciona porta }

    sock := socket (AF_INET, SOCK_DGRAM, IPPROTO_UDP);
    if (sock = -1) then exit;

    abreConexaoUDP := sock;
end;

function escutaConexaoUDP (porta: short): integer;
var
    localAddr: sockaddr_in;               { descricao dos endereos local e remoto }
    ret: integer;
    sock: integer;

begin
    escutaConexaoUDP := -1;

    sock := socket (AF_INET, SOCK_DGRAM, IPPROTO_UDP);
    if (sock = -1) then exit;

    fillchar (localAddr, sizeof (localAddr), 0);
    with localAddr do
        begin
            sin_family := AF_INET ;
            sin_addr.s_addr := htonl (INADDR_ANY);
            sin_port := word (htons (porta));
        end;

    ret := bind (sock, localAddr, sizeof(localAddr));
    if ret = -1 then exit;

    escutaConexaoUDP := sock;
end;

function writeRede (sock: integer; s: string): boolean;
var p: pointer;
begin
    p := @s[1];
    writeRede := sendBuf(sock, p, length (s), 0) > 0;
end;

function chegouRede (sock: integer): boolean;
var
    entradas: TFDset;
    tempoZero: timeVal;
begin

    with tempoZero do
        begin
            tv_sec := 0;
//            tv_usec := timeoutChegouRede;
            tv_usec := 0;
        end;

    FD_ZERO (entradas);         { monitora soquete }
    FD_SET (sock, entradas);
    select (sock+1, @entradas, NIL, NIL, @tempoZero);

    chegouRede := FD_ISSET (sock, entradas);
//    keypressed;
end;

function writelnRede (sock: integer; s: string): boolean;
var p: pointer;
begin
    s := s + #$0d + #$0a;
    p := @s[1];
    writelnRede := sendBuf (sock, p, length (s), 0) > 0;
end;

function readlnRede (sock: integer): string;
var buf: array [0..MAXBUF] of char;
iMode: u_Long;
    lidos: integer;
    s: string;
begin
if (not ChegouRede(sock)) then
begin
s:='<nul>';
exit;
end;
    lidos := recv (sock, buf, MAXBUF, 0);
    if lidos = 0 then
    begin
    readlnRede:='<desconectado>';
    exit;
    end;
    if lidos= -1 then
    begin
    ReadlnRede:='';
    exit;
    end;
     if lidos>0 then buf[lidos] := #$0;
     s :=buf;
     readlnRede := s;
end;

{ L uma linha baseado em Telnet }

function LeTelnet(sock: integer): string;
var lidos: integer;
buf: array[0..MAXBUF-1] of char;
s: string;
begin
    lidos := recv (sock, buf, MAXBUF, 0);
    if lidos = 0 then
    begin
    LeTelnet:='';
    exit;
    end;
    if lidos= -1 then
    begin
    LeTelnet:='';
    exit;
    end;
     if lidos>0 then buf[lidos] := #$0;
     s :=buf;
    LeTelnet:=s;
end;

function enviaUDP (sock: integer; buf: PChar; len: integer;
                   ipDestino: longint; porta: short): integer;
var remoteAddr: sockaddr_in;
begin
    fillchar (remoteAddr, sizeof (remoteAddr), 0);
    with remoteAddr do
        begin
            sin_family := AF_INET;
            move (ipDestino, sin_addr, 4);
            sin_port := word (htons (porta));
        end;

    enviaUDP := sendto(sock, buf^, len, 0, remoteAddr, sizeof (remoteAddr));
end;

function recebeUDP (sock: integer; buf: PChar; tamBuf: integer; var ipOrigem: longint): integer;
var fromAddr: sockaddr_in;
    tam: longint;
begin
    tam := sizeof (fromAddr);
    fillchar (fromAddr, sizeof (fromAddr), 0);
    with fromAddr do
        begin
            sin_family := AF_INET ;
            sin_addr.s_addr := htonl (INADDR_ANY);
            sin_port := htons (0);
        end;

     recebeUDP := recvfrom (sock, buf^, tamBuf, 0, fromAddr, tam);
     ipOrigem := fromAddr.sin_addr.s_addr;
end;

function inicBufRede (sock: integer): PbufRede;
var pbuf: PBufRede;
begin
    getMem (pbuf, sizeof (TBufRede));
    pbuf^.p := MAXBUF;
    pbuf^.lidos := 0;
    pbuf^.sock := sock;
    inicBufRede := pbuf;
end;

procedure fimBufRede (pbuf: PbufRede);
begin
    freeMem (pbuf, sizeof (TBufRede));
end;

function temDadoBufRede (pbuf: PbufRede): boolean;
begin
    temDadoBufRede := false;
    if pbuf = NIL then exit;

    with pbuf^ do
        temDadoBufRede := (p < lidos) or chegouRede (sock);
end;

function leCaracBufRede (pbuf: PbufRede; var c: char): boolean;
begin
    leCaracBufRede := false;
    c := #$0;
    if pbuf = NIL then exit;

    with pbuf^ do
        begin
            if p >= lidos then
                begin
                    p := 0;
                    lidos := recv (sock, buf, MAXBUF, 0);
                    if lidos <= 0 then exit;
                end;

            c := buf [p];
            p := p + 1;
        end;

    leCaracBufRede := true;
end;

function readlnBufRede (pbuf: PbufRede; var s: string; maxTempo: integer): boolean;
var c: char;
    contaTempo: integer;
begin
    readlnBufRede := false;
    s := '';

    contaTempo := 0;
    repeat
        while not temDadoBufRede (pbuf) do
            begin
sleep (100);
                contaTempo := contaTempo + 1;
                if maxTempo <> 0 then
                    if contaTempo > (maxTempo*10) then exit;
            end;

        if not leCaracBufRede (pbuf, c) then
        begin
            if s = '' then exit else break
        end;

        if c = #$0a then break;

        s := s + c
    until false;

    if (s <> '') and (s[length(s)] = #$0d) then
        delete (s, length (s), 1);

    readlnBufRede := true;
end;

procedure AceitaHTTP(sock: integer; codigo: string; conteudo: string);
var s: TStringList;
i: integer;
begin
s:=TStringList.Create;
s.Add('HTTP/1.0 200 OK');
s.Add('Server: ChatServ');
s.Add('Pragma: no-cache');
s.Add('Cache-Control: max-age=0');
s.Add('Expires: Thu, 01 Jan 1970 00:00:00 GMT');
s.Add('Content-Type: text/html; charset=iso-8859-1');
s.Add('Connection: keep-Alive');
s.Add('');
for i:=0 to s.Count-1 do
begin
writelnRede(sock,s[i]);
sleep(1);
end;
writelnRede(sock,conteudo);
sleep(1);
s.Free;
end;

{ Realiza uma requisio HTTP }

function Requisita(sock: integer; metodo: byte; host: string; dados:
string): string;
var tiroCurto: string;
resposta,s: string;
begin
if sock<=0 then
begin
Requisita:='erro';
exit;
end;
case metodo of
0: tiroCurto:='GET';
1: tiroCurto:='POST';
end;
writelnRede(sock,tiroCurto+' '+dados+' HTTP/1.1');
writelnRede(sock,'Host: '+host);
writelnRede(sock,'');
s:=readlnRede(sock);
resposta:=s;
while chegouRede(sock) do
begin
s:=readlnRede(sock);
resposta:=resposta+s;
end;
Requisita:=resposta;
end;

begin
    debugConexao := false;
end.
