{
Interface para download de arquivos via HTTP
Por Novo Nego e Velho Nego
Parte do cdigo aproveitada do Webvox
Copyright (c) 2017 - Sociedade dos Nego
Em 06/08/2017
}

unit download;
interface
function BaixaArquivo(link: string; nomeArq: string): boolean;
implementation
uses dvcrt, dvinet, dvssl, dvwin, classes, sysutils, winsock;
const
BUFSIZE = 24576;
NCON='No consegui realizar a conexo';

var
erro: boolean=false;

function BaixaArquivo(link: string; nomeArq: string): boolean;
var arq: file;

procedure falaTamanhoArq (tam: int64);
var
    medida: char;
    decimal: longint;
begin
    medida := ' ';
    if tam >= 65536 then
        begin
            medida := 'K';
            decimal := tam mod 1024;
            tam := tam div 1024;
            if decimal > 512 then tam := tam + 1;
        end;

    sintWrite (intToStr (tam) + medida);
end;

function extraiDominio(s: string): string;
var d: string;
begin
d := copy(s, pos('/', s) + 2, length(s));
if pos('/', d) <= 0 then
extraiDominio := d
else
extraiDominio := copy(d, 1, pos('/', d) - 1);
end;

procedure obter(link: string);
var sock, i, j: integer;
resp: TStringList;
dominio, resto, s: string;
tamanho: int64;
trazidos: int64;
bufHeader: pBufRede;
bufRecebe: array[0..BUFSIZE-1] of char;
c, opCancel: char;
comClek: boolean;
label baixa;
function TrazHeader: string;
var bufinho: array[0..1] of char;
s: string;
lidos: integer;
begin
TrazHeader:='';
lidos:=0;
while copy(s,length(s)-3,length(s))<>#13+#10+#13+#10 do
begin
try
lidos:=ReceiveBuf(sock,bufinho,1,0);
Except
end;
s:=s+bufinho;
end;
trazHeader:=s;
end;
begin
dominio := extraiDominio(link);
resto := copy(link, pos(dominio, link) + length(dominio), length(link));
comClek := true;
if maiuscAnsi(copy(link, 1, 5)) = 'HTTPS' then
sock := abreConexaoSsl(dominio, 443)
else
sock := abreConexao(dominio, 80);
if sock <= 0 then
begin
sintWriteln(NCON);
erro := true;
exit;
end;
writelnRede(sock, 'GET ' + resto + ' HTTP/1.1');
writelnRede(sock,'Host: ' + dominio);
writelnRede(sock,'User-Agent: download (Sociedade dos Nego)');
writelnRede(sock,'UA-CPU: x86');
writelnRede(sock,'');
resp:=TStringList.Create;
assign(arq, nomeArq);
{$I-} rewrite(arq, 1); {$I+}
if IOResult <> 0 then
begin
sintWriteln('No consegui abrir o arquivo '+nomeArq+' para escrita');
erro := true;
exit;
end;
//trazidos := 0;
s:=TrazHeader;
if s='' then
begin
sintWriteln('Conexo caiu');
try
close(arq);
Except
end;
erro:=true;
exit;
end;
resp.text:=s;
for i:=0 to resp.Count-1 do
begin
s:=resp[i];
if copy(s, 1, 8) = 'Location' then
begin
fechaConexao(sock);
obter(copy(s, pos(':', s) + 2, length(s)));
exit;
end
else if copy(s, 1, 14) = 'Content-Length' then
tamanho := strToInt(copy(s, pos(':', s) + 2, length(s)));
end;
baixa:
{ Achou o arquivo; baixa }
while trazidos <> tamanho do
begin
i := receiveBuf(sock, bufRecebe, BUFSIZE, 0);
if i <= 0 then
begin
erro := true;
sintWriteln('Conexo caiu');
close(arq);
exit;
end;
trazidos := trazidos + i;
            {$I-}  blockWrite (arq, bufRecebe, i);  {$I+}
if IOResult <> 0 then
begin
erro := true;
sintWriteln('Erro de escrita no arquivo');
exit;
end;
if comClek then sintClek;
                if keypressed then
                    begin
                        c := readkey;
                        if c = ' ' then
                            begin
                                comClek := not comClek;
                                sintBip;
                            end
                        else
                        if c = #$1b then
                            begin
sintWriteln('Confirma o cancelamento do download?');
                                opCancel:= sintReadKey;
                                writeln;
                                if upcase(opCancel) = 'S' then
                                begin
erro:=true;
sintWriteln('Download interrompido');
close(arq);
                                    exit;
                                end;
                            end
                        else
                            begin
                                write (#$0d);  clreol;
                                sintWriteInt ((trazidos * 100) div tamanho);
                                        sintWrite ('% de ');
                                        falaTamanhoArq (tamanho);
                                sintWrite (' '+nomeArq);
                                write ('  ');
                            end;
                    end;
end;
close(arq);
end;

    begin
obter(link);
BaixaArquivo := erro;
try
Close(arq);
Except
end;
end;
end.
