// BaixaTube - Acesso e busca de vdeos no Google
// Por Velho Nego, coloque seu nome aqui
// Em 5 de agosto de 2017
// Atualizado em 03/08/2019

unit btgoogle;
interface
uses strUtils, dvCrt, dvForm, tubeutils, classes, dvwin, dvinet, HTTPApp, sysUtils, winsock;
type
tSite = record
nome: string;
urlbase: string;
end;

var
pagina: integer=0;
links, titulos: TStringList;

procedure BuscaGoogle(s: string);
function MontaLista(site: tSite): boolean;
function FolheiaSite: byte;
function NomeSite(s: string): string;
function urlSite(s: string): string;
procedure LimpaBuf;
implementation
uses btmsg, btvars;

var
n: integer;
r: string;

function ExisteLinkLista(l: string): boolean;
var i: integer;
begin
ExisteLinkLista:=false;
for i:=0 to links.Count-1 do
if (pos(l,links[i])<>0) or (links[i]=l) then
ExisteLinkLista:=true;
end;

procedure BuscaGoogle(s: string);
var sock: integer;
buf: array[0..262143] of char;
iMode: u_Long;
lidos: integer;
begin
iMode:=1;
AbreWinSock;
sock:=AbreConexaoSSL('google.com',443);
if sock<=0 then exit;
writelnRede(sock,'GET /search?q='+httpEncode(s)+'&tbm=vid&ie=UTF-8&gbv=1&start='+intToStr(pagina)+ ' HTTP/1.1');
writelnRede(sock,'Host: www.google.com.br');
writelnRede(sock,'User-Agent: BaixaTube');
writelnRede(sock,'UA-CPU: x86');
writelnRede(sock,'');
ioctlSocket(sock,FIONBIO,iMode);
while pos('</script></body></html>',s)=0 do
begin
s:=readlnRede(sock);
r:=r+s;
end;
r:=StringReplace(r,'<b>','',[rfReplaceAll, rfIgnoreCase]);
r:=StringReplace(r,'</b>','',[rfReplaceAll, rfIgnoreCase]);
r:=StringReplace(r,'</a></h3>','</titulo>',[rfReplaceAll, rfIgnoreCase]);
//if pos('200 OK',r)<>0 then
end;

procedure LimpaBuf;
begin
r:='';
try
titulos.Free; links.Free;
Except
end;
end;

function MontaLista(site: tSite): boolean;
var
i: integer;
s,t: string;
p: integer;
procedure PegaVideos;
var t,u: string;
begin
s:=r;
while pos(site.urlbase,s)<>0 do
begin
delete(s,1,pos(site.urlbase,s)-1);
t:=copy(s,1,pos('</div></a></div><div class="',s)-1);
u:=t;
delete(t,pos('&',t),length(t));
delete(u,1,pos('">',u));
delete(u,1,pos('">',u)+1);
delete(u,pos('</div>',u),length(u));
if not ExisteLinkLista(t) then
begin
 links.Add('https'+t);
titulos.add(u);
end;
delete(s,1,pos(site.urlbase,s));
delete(s,1,pos('</div></a></div><div class="',s));
delete(s,1,pos('&',s));
end;
end;
begin
MontaLista:=true;
s:=r;
links:=TStringList.Create; titulos:=TStringList.Create;
PegaVideos;
cabecalho;
sintWriteln(intToStr(titulos.Count)+' vdeos encontrados'); writeln;
if titulos.Count=0 then
begin
MontaLista:=false;
exit;
end;
end;

function GeraInfoVideo(nome: string; url: string): tInfoFilme;
var
filme: tInfoFilme;
begin
filme.titulo:=nome;
filme.id:=url;
GeraInfoVideo:=filme;
end;

procedure InfoVideo;
var titulo: string;
begin
cabecalho;
titulo:=TituloPagina(links[n-1]);
if titulo<>'' then
sintWriteln('Ttulo do vdeo: '+titulo)
else
sintWriteln('Ttulo do vdeo no disponvel');
sintWriteln('Orgem: '+site.nome);
sintWriteln('Aperte C para copiar as informaes para a rea de transferncia');
if upcase(readkey)='C' then
begin
PutClipBoard(pchar(titulo+#13+#10+links[n-1]));
sintClek; sintClek;
end;
end;

function FolheiaSite: byte;
var i: integer;
c1, c2: char;
label ListaVideos;
begin
folheiaSite:=1;
FolheiaCria(wherex,wherey,80,24);
for i:=0 to titulos.Count-1 do folheiaAdiciona(titulos[i]);
n:=1;
ListaVideos:
folheiaExecuta(n,n,c1,c2,true);
c1:=upcase(c1);
case c2 of
F1: Ajuda;
F9: c1:=SelSetasOpcao;
end;
case c1 of
ESC: exit;
'S': BaixaVideo(GeraInfoVideo(titulos[n-1],links[n-1]));
'I': InfoVideo;
'A': begin
if pagina=0 then
begin
sintWriteln('Primeira pgina');
goto ListaVideos;
end;
pagina:=pagina-10;
LimpaBuf;
FolheiaSite:=0;
exit;
end;
'P': begin
pagina:=pagina+10;
LimpaBuf;
FolheiaSite:=0;
exit;
end;
        ^l:
            begin
                putClipboard (pchar(links[n-1]));
                sintclek;
            end;
        ^C:
             begin
                putClipboard (pchar(titulos[n-1]+#$0d+#$0a+links[n-1]));
sintClek;
end;
CTLENTER: begin
TocaNavegador(links[n-1]);
end;
ENTER: TocaVideo(GeraInfoVideo(titulos[n-1],links[n-1]));
end;

goto ListaVideos;
end;

function NomeSite(s: string): string;
begin
if pos(#255,s)<>0 then
mensagem('BTADULTO');
s:=StringReplace(s,#255,'',[rfReplaceAll, rfIgnoreCase]);
NomeSite:=copy(s,1,pos('=',s)-1);
end;

function urlSite(s: string): string;
begin
urlSite:=copy(s,pos('=',s)+1,length(s));
end;
end.
