unit btcfg;
interface
uses dvCrt, dvWin, dvForm, sysUtils, windows;
type
tConf = record
dirvideos: string;
volume: string;
altf4: string;
end;
var confs: tConf;
procedure CarregaConf;
procedure Configura;
implementation
uses fileCtrl, tubeutils;
procedure CarregaConf;
begin
with confs do
begin
dirvideos:=sintAmbiente('BAIXATUBE','DIRVIDEOS');
if dirvideos='' then
dirvideos:='.';
volume:=sintAmbiente('BAIXATUBE','VOLUME');
altf4:=sintAmbiente('BAIXATUBE','ALTF4');
end;
chdir(confs.dirvideos);
end;

procedure Configura;
label denovo;
procedure edita(var s: string);
begin
sintWriteln('Edite e pressione Enter');
sintEdita(s,wherex,wherey,80,true);
sintWriteln('Ok');
end;
function formulario: boolean;
begin
while true do
begin
formulario:=false;
cabecalho;
PopUpMenuCria(wherex,wherey,45,1,RED);
PopUpMenuAdiciona('','Diretrio de gravao dos vdeos');
PopUpMenuAdiciona('','Volume de reproduo');
PopUpMenuAdiciona('','Falar mensagem de ajuda ao iniciar a reproduo');
case PopUpMenuSeleciona of
0:
begin
formulario:=false;
exit;
end;
1: edita(confs.dirvideos);
2: Edita(confs.volume);
3: Edita(confs.altf4);
end;
end;
end;
var i: integer;
begin
cabecalho;
sintWriteln('Configuraes');
sintWriteln('Use as setas para selecionar uma configurao, e Enter para');
sintwriteln('alterar o valor.');
writeln;
denovo:
while formulario do;
if not DirectoryExists(confs.dirvideos) then
begin
sintWriteln('Diretrio informado no existe');
goto denovo;
end;
try
i:=strToInt(confs.volume);
Except
sintWriteln('Volume incorreto');
end;
if (i<1) or (i>3) then
begin
sintWriteln('Volume invlido, por favor, insira um valor entre 1 e 3');
goto denovo;
end;
if (confs.altf4<>'NAO') and (confs.altf4<>'SIM') then
confs.altf4:='SIM';
writePrivateProfileString('BAIXATUBE','DIRVIDEOS',pchar(confs.dirvideos ),'DOSVOX.INI');
writePrivateProfileString('BAIXATUBE','VOLUME',pchar(confs.volume),'DOSVOX.INI');
writePrivateProfileString('BAIXATUBE','ALTF4',pchar(confs.altf4),'DOSVOX.INI');
sintWriteln('Fim da configurao');
chdir(confs.dirvideos);
end;

end.
